require( "HiddenObject/script/style.lua" );


CheckBoxFont = {
  standardFont,
  18,
  WhiteColor
};

DialogBodyFont = {
  standardFont,
  22,
  WhiteColor
};

RectGraphics = {
	"HiddenObject/UI/Button/rectnormal.png",
	"HiddenObject/UI/Button/rectdown.png",
	"HiddenObject/UI/Button/rectover.png",
};	

RectStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	font = ButtonFont,
	graphics = RectGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};
MakeDialog
{
	-- Name the modal dialog
	name="bonusForcedHelp",
	Bitmap
	{
		image="HiddenObject/UI/background/dialog",
		x = kCenter,
		y = kCenter - 44,
		
		Text
			{
				font = DialogBodyFont,
				name = "quickfindmsg",
				x = 70,
				y = 95,
				w = kMax - 60,
				h = kMax,
				flags = kHAlignLeft + kVAlignTop,
				label="quickfindmsg",
			};		
		
		SetStyle(CheckboxButtonStyle),			
		Button
		{
			x = 70,
			y = 145,
			w = 300,
			scale = 0.7,
			
			Text
				{
					font = CheckBoxFont,
					name = "DontShowAgain",
					x=kCenter + 20,
					y=5,
					w=kMax,
					h=32,
					flags = kHAlignLeft + kVAlignTop,
					label="DontShowAgain",
				};
			command =
				function()
					ToggleForcedBonusHelp();
				end				
		},
		
		SetStyle(RectStyle),
		Button
        {
			font = StandardButtonFont,
			graphics = RectGraphics,
            close = true,
            flags = 5,
            label = "ok",
            name = "ok",
           x = kCenter,
           y = -75,
        },
	},
}